import java.io.DataInputStream
import java.io.DataOutputStream
import java.io.IOException
import java.net.Socket
import java.util.logging.Level
import java.util.logging.Logger

object Cliente {
    @JvmStatic
    fun main(args: Array<String>) {
        //Host del servidor
        val HOST = "127.0.0.1"
        //Puerto del servidor
        val PUERTO = 5000

        lateinit var socket: Socket
        lateinit var input: DataInputStream
        lateinit var out: DataOutputStream
        lateinit var mensaje: String

        try {
            //Creo el socket para conectarme con el cliente
            socket = Socket(HOST, PUERTO)

            input = DataInputStream(socket.getInputStream())
            out = DataOutputStream(socket.getOutputStream())

            //Envio un mensaje al cliente
            out.writeUTF("¡Hola mundo desde el cliente!")

            //Recibo el mensaje del servidor
            mensaje = input.readUTF()

            println(mensaje)

            socket.close()
        } catch (ex: IOException) {
            Logger.getLogger(Cliente::class.java.getName()).log(Level.SEVERE, null, ex)
        }
    }
}
