import java.io.DataInputStream
import java.io.DataOutputStream
import java.io.IOException
import java.net.ServerSocket
import java.net.Socket
import java.util.logging.Level
import java.util.logging.Logger

object Servidor {
    @kotlin.jvm.JvmStatic
    fun main(args: Array<String>) {
        lateinit var servidor: ServerSocket
        lateinit var socket: Socket
        lateinit var input: DataInputStream
        lateinit var out: DataOutputStream

        //puerto de nuestro servidor
        val PUERTO = 5000

        try {
            //Creamos el socket del servidor
            servidor = ServerSocket(PUERTO)
            println("Servidor iniciado")

            //Siempre estara escuchando peticiones
            while (true) {
                //Espero a que un cliente se conecte

                socket = servidor.accept()

                println("Cliente conectado")
                input = DataInputStream(socket.getInputStream())
                out = DataOutputStream(socket.getOutputStream())

                //Leo el mensaje que me envia
                val mensaje = input.readUTF()

                println(mensaje)

                //Le envio un mensaje
                out.writeUTF("¡Hola mundo desde el servidor!")

                //Cierro el socket
                socket.close()
                println("Cliente desconectado")
            }
        } catch (ex: IOException) {
            Logger.getLogger(Servidor::class.java.getName()).log(Level.SEVERE, null, ex)
        }
    }
}
