import java.io.IOException
import java.net.*
import java.util.logging.Level
import java.util.logging.Logger

object Cliente {
    @JvmStatic
    fun main(args: Array<String>) {
        //puerto del servidor
        val PUERTO_SERVIDOR = 5000
        //buffer donde se almacenara los mensajes
        var buffer = ByteArray(1024)

        lateinit var direccionServidor: InetAddress
        lateinit var socketUDP: DatagramSocket
        lateinit var mensaje: String
        lateinit var peticion: DatagramPacket

        if (args.size != 1) {
            System.err.println("Uso: java Cliente direccionIP")
        } else {
            try {
                //Obtengo la localizacion de localhost
                //InetAddress direccionServidor = InetAddress.getByName("localhost");
                direccionServidor = InetAddress.getByName(args[0])

                //Creo el socket de UDP
                socketUDP = DatagramSocket()

                mensaje = "¡Hola mundo desde el cliente!"

                //Convierto el mensaje a bytes
                buffer = mensaje.toByteArray()

                //Creo un datagrama
                val pregunta = DatagramPacket(buffer, buffer.size, direccionServidor, PUERTO_SERVIDOR)

                //Lo envio con send
                println("Envio el datagrama")
                socketUDP.send(pregunta)

                //Preparo la respuesta
                peticion = DatagramPacket(buffer, buffer.size)

                //Recibo la respuesta
                socketUDP.receive(peticion)
                println("Recibo la peticion")

                //Cojo los datos y lo muestro
                mensaje = String(peticion.getData())
                println(mensaje)

                //cierro el socket
                socketUDP.close()
            } catch (ex: SocketException) {
                Logger.getLogger(Cliente::class.java.getName()).log(Level.SEVERE, null, ex)
            } catch (ex: UnknownHostException) {
                Logger.getLogger(Cliente::class.java.getName()).log(Level.SEVERE, null, ex)
            } catch (ex: IOException) {
                Logger.getLogger(Cliente::class.java.getName()).log(Level.SEVERE, null, ex)
            }
        }
    }
}

