import java.io.IOException
import java.net.DatagramPacket
import java.net.DatagramSocket
import java.net.InetAddress
import java.net.SocketException
import java.util.logging.Level
import java.util.logging.Logger

object Servidor {
    @JvmStatic
    fun main(args: Array<String>) {
        val PUERTO = 5000
        var buffer = ByteArray(1024)

        lateinit var direccionCliente: InetAddress
        lateinit var socketUDP: DatagramSocket
        var puertoCliente: Int = 0
        lateinit var mensaje: String
        lateinit var peticion: DatagramPacket
        lateinit var respuesta: DatagramPacket

        try {
            println("Iniciado el servidor UDP")
            //Creacion del socket
            socketUDP = DatagramSocket(PUERTO)

            //Siempre atendera peticiones
            while (true) {
                //Preparo la respuesta
                peticion = DatagramPacket(buffer, buffer.size)

                //Recibo el datagrama
                socketUDP.receive(peticion)
                println("Recibo la informacion del cliente")

                //Convierto lo recibido y mostrar el mensaje
                mensaje = String(peticion.getData())
                println(mensaje)

                //Obtengo el puerto y la direccion de origen
                //Sino se quiere responder, no es necesario
                puertoCliente = peticion.getPort()
                direccionCliente = peticion.getAddress()

                mensaje = "¡Hola mundo desde el servidor!"
                buffer = mensaje.toByteArray()

                //creo el datagrama
                respuesta = DatagramPacket(buffer, buffer.size, direccionCliente, puertoCliente)

                //Envio la información
                println("Envio la informacion del cliente")
                socketUDP.send(respuesta)
            }
        } catch (ex: SocketException) {
            Logger.getLogger(Servidor::class.java.getName()).log(Level.SEVERE, null, ex)
        } catch (ex: IOException) {
            Logger.getLogger(Servidor::class.java.getName()).log(Level.SEVERE, null, ex)
        }
    }
}
